﻿// Render module for formly to display forms
angular.module('formlyProject.render', []);
// Main Formly Module
angular.module('formlyProject', ['formlyProject.render']);
'use strict';
angular.module('formlyProject.render').directive('formlyFieldProject', [
  '$http',
  '$compile',
  '$templateCache',
  'formlyTemplate',
  function formlyFieldProject($http, $compile, $templateCache, formlyTemplate) {
      return {
          restrict: 'AE',
          transclude: true,
          scope: {
              optionsData: '&options',
              editmode: '@editmode',
              formId: '=formId',
              index: '=index',
              value: '=formValue'
          },
          link: function fieldLink($scope, $element, $attr) {
              var template = $scope.options.template;
              if (template) {
                  setElementTemplate(template);
              } else {
                  var templateUrl = $scope.options.templateUrl || formlyTemplate.getTemplateUrl($scope.options.type);
                  if (templateUrl) {
                      $http.get(templateUrl, { cache: $templateCache }).then(function (response) {
                          setElementTemplate(response.data);
                      }, function (error) {
                          window.console && window.console.log('Formly Error: Problem loading template for ' + templateUrl, error);
                      });
                  } else {
                      window.console && window.console.log('Formly Error: template type \'' + $scope.options.type + '\' not supported.');
                  }
              }
              function setElementTemplate(templateData) {
                  $element.html(templateData);
                  $compile($element.contents())($scope);
              }
          },
          controller: [
            '$scope',
            function fieldController($scope) {
                $scope.options = $scope.optionsData();
                if (typeof $scope.options.default !== 'undefined') {
                    $scope.value = $scope.options.default;
                }
                var type = $scope.options.type;
                if (!type && $scope.options.template) {
                    type = 'template';
                } else if (!type && $scope.options.templateUrl) {
                    type = 'templateUrl';
                }
                // set field id to link labels and fields
                $scope.id = $scope.formId + type + $scope.index;
            }
          ]
      };
  }
]);
'use strict';
angular.module('formlyProject.render').directive('formlyForm', [
  'formlyOptions',
  '$compile',
  function formlyForm(formlyOptions, $compile) {
      return {
          restrict: 'AE',
          templateUrl: 'Project/Templates/formly/formly-form.html',
          replace: true,
          scope: {
              fields: '=',
              options: '=?',
              result: '=',
              formOnParentScope: '=name'
          },
          compile: function (scope, iElement, iAttrs, controller, transcludeFn) {
              return {
                  post: function (scope, ele, attr, controller) {
                      scope.options = angular.extend(formlyOptions.getOptions(), scope.options);
                      if (scope.options.submitButtonTemplate) {
                          ele.find('button').replaceWith($compile(scope.options.submitButtonTemplate)(scope));
                      }
                      //Post gets called after angular has created the FormController
                      //Now pass the FormController back up to the parent scope
                      scope.formOnParentScope = scope[attr.name];
                  }
              };
          },
          controller: [
            '$scope',
            '$element',
            '$parse',
            function ($scope, $element, $parse) {
                // setup watches for watchExpressions
                angular.forEach($scope.fields, function (field, index) {
                    if (angular.isDefined(field.watch)) {
                        var watchExpression = field.watch.expression;
                        if (angular.isFunction(watchExpression)) {
                            // wrap the field's watch expression so we can call it with the field as the first arg as a helper
                            watchExpression = function () {
                                var args = Array.prototype.slice.call(arguments, 0);
                                args.unshift(field);
                                return field.watch.expression.apply(this, args);
                            };
                        }
                        $scope.$watch(watchExpression, function () {
                            // wrap the field's watch listener so we can call it with the field as the first arg as a helper
                            var args = Array.prototype.slice.call(arguments, 0);
                            args.unshift(field);
                            return field.watch.listener.apply(this, args);
                        });
                    }
                });
                $scope.$watch('result', function (newValue) {
                    angular.forEach($scope.fields, function (field, index) {
                        if (field.hideExpression) {
                            field.hide = $parse(field.hideExpression)($scope.result);
                        }
                    });
                }, true);
            }
          ]
      };
  }
]);
'use strict';
angular.module('formlyProject.render').provider('formlyOptions', function () {
    var options = {
        uniqueFormId: null,
        submitCopy: 'Submit',
        hideSubmit: false,
        submitButtonTemplate: null
    };
    function setOption(name, value) {
        if (typeof name === 'string') {
            options[name] = value;
        } else {
            angular.forEach(name, function (val, name) {
                setOption(name, val);
            });
        }
    }
    function getOptions() {
        // copy to avoid third-parties manipulating the options outside of the api.
        return angular.copy(options);
    }
    this.setOption = setOption;
    this.getOptions = getOptions;
    this.$get = function formlyOptions() {
        return this;
    };
});
'use strict';
angular.module('formlyProject.render').provider('formlyTemplate', function () {
    var templateMap = {
        textarea: 'Project/Templates/formly/formly-field-textarea.html',
        radio: 'Project/Templates/formly/formly-field-radio.html',
        select: 'Project/Templates/formly/formly-field-select.html',
        number: 'Project/Templates/formly/formly-field-number.html',
        checkbox: 'Project/Templates/formly/formly-field-checkbox.html',
        //password: 'Project/Templates/formly/formly-field-password.html',
        hidden: 'Project/Templates/formly/formly-field-hidden.html',
        email: 'Project/Templates/formly/formly-field-email.html',
        text: 'Project/Templates/formly/formly-field-text.html'
    };
    function setTemplateUrl(name, templateUrl) {
        if (typeof name === 'string') {
            templateMap[name] = templateUrl;
        } else {
            angular.forEach(name, function (templateUrl, name) {
                setTemplateUrl(name, templateUrl);
            });
        }
    }
    function getTemplateUrl(type) {
        return templateMap[type];
    }
    ;
    this.setTemplateUrl = setTemplateUrl;
    this.getTemplateUrl = getTemplateUrl;
    this.$get = function formlyTemplate() {
        return this;
    };
});

